import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/**
  *
  * Beschreibung
  *
  * @version 1.0 vom 28.06.2013
  * @author vom Hau
  */

public class Vigenere extends JFrame {
  // Anfang Attribute
  private EinAus ein, aus;
  private JLabel jLabel1 = new JLabel();
  private JButton btVerschluesseln = new JButton();
  private JButton btEnde = new JButton();
  private JTextField tfSchluessel = new JTextField();
  // Ende Attribute
  
  public Vigenere(String title) {
    // Frame-Initialisierung
    super(title);
    setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
    int frameWidth = 300; 
    int frameHeight = 178;
    setSize(frameWidth, frameHeight);
    
    setLocation(50, 100);
    setResizable(false);
    Container cp = getContentPane();
    cp.setLayout(null);
    // Anfang Komponenten
    
    jLabel1.setBounds(7, 7, 106, 20);
    jLabel1.setText("Schlsselwort");
    cp.add(jLabel1);
    btVerschluesseln.setBounds(8, 72, 129, 33);
    btVerschluesseln.setText("verschlsseln");
    btVerschluesseln.setMargin(new Insets(2, 2, 2, 2));
    btVerschluesseln.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        btVerschluesseln_ActionPerformed(evt);
      }
    });
    cp.add(btVerschluesseln);
    btEnde.setBounds(152, 72, 129, 33);
    btEnde.setText("Ende");
    btEnde.setMargin(new Insets(2, 2, 2, 2));
    btEnde.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        ein.dispose(); aus.dispose();
        System.exit(0);
      }
    });
    cp.add(btEnde);
    setTitle("Monoalphabetische Substitution");
    tfSchluessel.setBounds(7, 33, 221, 20);
    tfSchluessel.setText("HEUTE");
    cp.add(tfSchluessel);
    // Ende Komponenten
    ein = new EinAus("Eingabe");
    aus = new EinAus("Ausgabe");
    aus.setLocation(470,420);
    ein.schreibeZeile("TESTTEXT");
    setVisible(true);
  } // end of public Vigenere
  
  // Anfang Methoden
  public void btVerschluesseln_ActionPerformed(ActionEvent evt) {
    String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    String einString, ausString, schluessel;
    int nr, nr2, chiffre;
    
    einString = ein.getZeile(0);
    ausString = "";
    schluessel = tfSchluessel.getText();
    while (schluessel.length() < einString.length())
        schluessel = schluessel + schluessel;
    
    for (int i=0;i<einString.length() ;i++ ) {
    
      nr = alphabet.indexOf( einString.charAt(i));
      nr2 = alphabet.indexOf( schluessel.charAt(i));
      chiffre = (nr + nr2) % alphabet.length();
      
      if (nr > -1) {
        ausString = ausString + alphabet.charAt(chiffre);
      } // end of if
      
      
    } // end of for
    aus.schreibeZeile(ausString);
  } // end of btVerschluesseln_ActionPerformed
  
  
  
  public static void main(String[] args) {
    new MonoAlphAnwendung("CaesarAnwendung");
  } // end of main
  
} // end of class MonoAlphAnwendung
